<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <title>Investment Details_System</title>
  <link rel="stylesheet" href="/mamber/layui.css">
  <link rel="stylesheet" href="/mamber/common.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
  <style>
    .product_name {
      font-family: PingFang SC, PingFang SC;
      font-weight: 700;
      font-size: 24px;
      color: #FFFFFF;
      line-height: 24px;
    }
    .dashed {
      border-top: 1px dashed #cccccc;
      height: 1px;
      overflow: hidden;
    }
    .dashed:before, .dashed:after {
      display: block;
      position: absolute;
      content: "";
      width: 20px;
      height: 20px;
      background-color: #f3f5f9;
      border-radius: 50%;
      top: -10px;
    }
    .dashed:before { left: -10px; }
    .dashed:after { right: -10px; }
    .buy_btn { background: #053c8f !important; }
    .cancel { background: #818393 !important; }
    .confirm { background: #d2aa69 !important; }
  </style>
</head>
<body class="common_body">
  <div class="common_header common_header_order" style="height: 150px;background:#d2aa69;">
    <a href="javascript:history.back(-1)" class="back position">
      <p class="btn"><i class="layui-icon layui-icon-left layui-font-20"></i></p>
      Investment Details
    </a>
    <div style="padding: 10px 20px;">
      <p class="product_name"><?php echo e($package->name ?? 'VIP Fund 1'); ?></p>
    </div>
  </div>

  <div class="product_details_main">
    <div class="product_details_card" style="padding: 0px">
      <div style="border-radius: 16px;padding: 15px">
        <div>
          <div>Investment Amount</div>
          <div style="font-size:28px;font-weight:bold;padding-left:10px;">
            <?php echo e(price($package->price ?? 350)); ?>

          </div>
        </div>

        <div class="product_details_item" style="border-bottom: none">
          <div>
            <p>Investment Stocks</p>
            <p class="label" style="margin-top: 5px;font-size:24px;">1</p>
          </div>
          <div>
            <p>Period Income</p>
            <p class="label" style="margin-top: 5px;font-size:24px;">
              <?php echo e($package->commission_with_avg_amount ?? '175'); ?>

            </p>
          </div>
        </div>

        <div style="padding: 15px">
          <div class="product_details_item">
            <div style="font-weight: 700; font-size: 13px; color: #666; height: 30px; line-height: 30px; width: 80px;">
              Min 1
            </div>
            <div id="ID-slider-demo-value" style="width: 80%; margin-top: 12px;">
              <div class="layui-slider">
                <div class="layui-slider-tips" style="left: 100%; display: inline-block;">1</div>
                <div class="layui-slider-bar" style="background:#27C85D; width:100%;left:0;"></div>
                <div class="layui-slider-wrap" style="left:100%;">
                  <div class="layui-slider-wrap-btn" style="border: 2px solid #27C85D;"></div>
                </div>
              </div>
            </div>
            <div style="padding-left: 10px; width: 80px; font-weight: 700; font-size: 13px; color: #666; height: 30px; line-height: 30px;">
              Max 1
            </div>
          </div>

          <div class="layui-btn layui-btn-lg layui-btn-radius buy-btn layui-btn-fluid buy_btn" onclick="buyConfirm()">
            Invest Now
          </div>
        </div>

        <div class="product_details_card" style="color:#2a415c;">
          <div style="font-size:24px; color:#2a415c; font-weight:bold;">Stable Income</div>
          <div style="display:flex; justify-content:space-between; padding:10px 5px;">
            <div>Price per Unit</div>
            <div style="font-size:18px;"><?php echo e(price($package->price)); ?></div>
          </div>
          <div style="display:flex; justify-content:space-between; padding:10px 5px;">
            <div>Income Duration</div>
            <div><?php echo e($package->validity); ?> days</div>
          </div>
          <div style="display:flex; justify-content:space-between; padding:10px 5px;">
            <div>Total Income</div>
            <div><?php echo e(price(($package->commission_with_avg_amount ?? 0) * 1)); ?></div>
          </div>
          <div style="display:flex; justify-content:space-between; padding:10px 5px;">
            <div>Required Level</div>
            <div>
              <img src="/mamber/img/lv0.svg" style="height: 28px; width: 28px">
            </div>
          </div>
          <div style="display:flex; justify-content:space-between; padding:10px 5px;">
            <div>Maximum</div>
            <div>1</div>
          </div>
        </div>

        <div class="product_details_card" style="color:#2a415c;">
          <div class="product_details_name" style="border-left: 4px solid #EBD8A3; padding-left: 10px;">
            Caring Fund
          </div>
          <div style="font-family: Arial; font-weight: 400; font-size: 14px; color: #2A415C; line-height: 22px;">
            <p style="margin-bottom: 10px;">Minimum investment for this product is <?php echo e(price($package->price)); ?></p>
            <p style="margin-bottom: 10px;">Duration: <?php echo e($package->validity); ?> days</p>
            <p style="margin-bottom: 10px;">Total Profit: <?php echo e(price(($package->commission_with_avg_amount ?? 0) * 1)); ?></p>
          </div>
        </div>

      </div>
    </div>
  </div>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <div class="loader loading" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 999;">
    <img src="<?php echo e(asset('public/loading.gif')); ?>" style="width: 100px;" alt="Loading">
  </div>

  <script>
    function buyConfirm() {
      document.querySelector('.loading').style.display = 'block';
      window.location.href = '<?php echo e(url('purchase/confirmation/' . $package->id)); ?>';
    }
  </script>
</body>
</html>
<?php /**PATH /home/zgvdquyg/public_html/resources/views/app/main/vip_details.blade.php ENDPATH**/ ?>