<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Pusat Misi</title>
    <link rel="stylesheet" href="/mamber/layui.css">
    <link rel="stylesheet" href="/mamber/common.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
    <style>

        .invite_btn{
            width: 47%;
            height: 40px;
            text-align: center;
            line-height: 40px;
            background: #396ED1;
            border-radius: 100px 100px 100px 100px;
            cursor: pointer;
        }
        .copy_link_btn{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 14px;
            color: #FFFFFF;

        }
        .qr_code_btn{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 14px;
            color: #FFFFFF;
            background: #29BE71;

        }
        .label{
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #333333;
            line-height: 22px;
        }
        .value{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 24px;
            color: #1E69C2;
            line-height: 28px;
        }
        .common_card .title{
            padding-left: 10px;
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 18px;
            color: #0F7A5A;
            height: 30px;
            line-height: 30px;
            display: flex;
            justify-content:space-between ;
        }
        .reward_card{
            height: auto;
            background-image: url("/public/site/img/tasks/bg.png");
            background-size: 100%;
            background-repeat: no-repeat;
            border-radius: 15px;
            padding-top: 40px;
        }

        .reward_icon{
            height: 30px;
            width: 30px;
        }
        .reward_card .title{
           padding-left: 15px;
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 18px;
            color: #333333;
        }
        .reward_card .label{
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #333333;
            line-height: 16px;
        }
        .reward_card .value{
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 16px;
            color: #333333;
            line-height: 18px;
        }
        .reward_card .content{
            margin-bottom: 15px;
            margin-top: unset;
            width: 100%;
        }
        .reward_text{
            margin-top: 10px;
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #666666;
            line-height: 24px;
        }
        .link{
            padding-left: 10px;
            margin-bottom: 10px;
        }
        .tasks_title{
            font-weight: 700;
            font-size: 13px;
            color: #666666;
            margin-top: 10px;
        }
        .tasks_timeline_value{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 14px;
            color: #333333;
            line-height: 24px;
            text-align: center;
            font-style: normal;
            text-transform: none;
        }
        .tasks_timeline_label{
            font-family: PingFang SC, PingFang SC;
            font-weight: 400;
            font-size: 14px;
            color: #888888;
            line-height: 18px;
            text-align: center;
            font-style: normal;
            text-transform: none;
        }
       .layui-timeline-title {
            font-family: PingFang SC, PingFang SC;
            font-weight: 400;
            font-size: 14px;
            color: #3D3D3D;
            line-height: 18px;
            text-align: left;
            font-style: normal;
            text-transform: none;
        }
        .layui-text p {
             margin: 0;
        }
    </style> 
</head>

<body class="member_body" style="background: #fff;">
    <div class="common_header" style="background: #d2aa69">
        <a href="javascript:history.back(-1)" class="back position" style="color: #000">
            <p class="btn" style="color: #000">
                <i class="layui-icon layui-icon-left layui-font-20"></i>
            </p>
            Pusat Misi
        </a>
    </div>

    <div style="background: #FFFFFF;border-radius: 12px;margin-top: 15px;padding: 10px;">
        <div class="layui-timeline" style="margin-top: 15px;">
            @php
                $tasks = \App\Models\Task::orderBy('id')->get();
                $completedTasks = \App\Models\TaskRequest::where('user_id', auth()->id())
                    ->where('status', '!=', 'rejected')
                    ->pluck('created_at', 'task_id');

                $referrals = \App\Models\User::where('ref_by', auth()->user()->ref_id)
                    ->where('investor', 1)
                    ->orderBy('created_at')
                    ->get();

                $startDate = null;
                $canShowNext = true;
            @endphp

            @foreach($tasks as $task)
                @php
                    $isCompleted = isset($completedTasks[$task->id]);
                    $target = $task->team_size ?? 1;
                    $filtered = $referrals->filter(function ($ref) use ($startDate) {
                        return !$startDate || $ref->created_at > $startDate;
                    });
                    $currentCount = $filtered->count();
                    $percentage = min(100, round(($currentCount / $target) * 100));
                @endphp

                <div class="layui-timeline-item">
                    <i class="layui-icon layui-timeline-axis layui-icon-time" style="color: #307BD5"></i>
                    <div class="layui-timeline-content layui-text">
                        <h3 class="layui-timeline-title">{{ $task->title ?? 'Invite '.$target.' people to activate' }}</h3>
                        <div class="flex_space" style="margin: 10px 0">
                            <div>
                                <p class="tasks_timeline_value">R{{ number_format($task->reward, 2) }}</p>
                                <p class="tasks_timeline_label">Reward</p>
                            </div>
                            <div>
                                <p class="tasks_timeline_value">{{ $target }}</p>
                                <p class="tasks_timeline_label">Orders</p>
                            </div>
                            <div>
                                <p class="tasks_timeline_value" style="color: #307BD5">{{ $currentCount }}</p>
                                <p class="tasks_timeline_label">Completed</p>
                            </div>
                            @if(!$isCompleted && $currentCount >= $target)
                                <button onclick="receivedReward(true)" style="background:#d2aa69;border:none;color:#fff;border-radius:15%;padding:0px 5px;">Claim</button>
                            @elseif($isCompleted)
                                <span style="color:green;font-weight:bold;">Claimed</span>
                            @else
                                <button onclick="receivedReward(false)" style="background:#ccc;border:none;color:#fff;border-radius:15%;padding:0px 5px;" disabled>Claim</button>
                            @endif
                        </div>
                    </div>
                </div>
                @php
                    if ($isCompleted) {
                        $startDate = $completedTasks[$task->id];
                    } else {
                        $canShowNext = false;
                    }
                @endphp
            @endforeach
        </div>
    </div>

    <div id="tasks_dialog" class="position" style="width: 260px;height: 260px;background: #FFFFFF;display: none;background-image:url('/public/site/img/tasks/rule_bg.png');background-repeat: no-repeat;background-size: 260px 260px;">
        <div>
            <div style="text-align: center">
                <img src="/public/site/img/tasks/rules_icon.png" style="width: 116px;height:110px;margin-top: 20px;">
            </div>
            <div class="tasks_title" style="padding:0 20px;text-align: center;font-weight: 700;font-size:20px;color: #000">
                Reward
            </div>
            <div class="tasks_text" style="font-family: Arial;font-weight: 400;font-size: 14px;color: #2A415C;line-height: 16px;text-align:center;margin-top: 10px;padding:0 20px;">
                If your friend upgrades to VIP1 or higher, you will receive a reward of ₦50.
            </div>
        </div>
    </div>

    <div class="footer_menu">
        <div class="content">
            <a href="/" class="item"> <img src="/mamber/img/logo.svg"> <p>About</p> </a>
            <a href="/invest" class="item"> <img src="/mamber/img/INCEST.svg"> <p>Investments</p> </a>
            <a href="/club" class="item"> <img src="/mamber/img/clbu.jpg" style="width:28px;"> <p>Club</p> </a>
            <a href="/myTeam" class="item"> <img src="/mamber/img/GIFTBOS.svg"> <p>Welfare</p> </a>
            <a href="/account" class="item"> <img src="/mamber/img/Account.svg"> <p>Account</p> </a>
        </div>
    </div>

    <textarea style="height: 1px;opacity: 0" name="copyTxt" id="copyTxt" readonly>https://namaskar.cc/?invitation_code={{ auth()->user()->ref_id }}</textarea>

    <div class="loader" style="position: fixed; display: none; top: 50%; z-index: 99; width: 143px; border-radius: 15px; overflow: hidden; left: 50%; transform: translate(-50%, -50%);">
        <img src="{{ asset('public/loading.gif') }}" style="width: 100%;" alt="">
    </div>

    @include('alert-message')

    <script>
        function copyLink(text) {
            const body = document.body;
            const input = document.createElement("input");
            body.append(input);
            input.style.opacity = 0;
            input.value = text.replaceAll(' ', '');
            input.select();
            input.setSelectionRange(0, input.value.length);
            document.execCommand("Copy");
            input.blur();
            input.remove();
            message('Copied successfully.');
        }

        function receivedReward(condition) {
            if (condition === true) {
                window.location.href = '{{ route("user.received.reward") }}';
            } else {
                message('Target not eligible.');
            }
        }

        function getDeposirreward(url) {
            document.querySelector('.loader').style.display = 'block';
            window.location.href = url;
        }
    </script>
</body>
</html>
