fphp
    $accountNumber = $bankAccount ? $bankAccount->bank_account : '';
    $accountName = $bankAccount ? $bankAccount->full_name : '';
    $bankName = $bankAccount ? $bankAccount->bank_name : '';
    $bankCode = $bankAccount ? $bankAccount->bank_code : '';
    $swiftCode = $bankAccount ? $bankAccount->ifsc : '';
    $phoneNumber = $bankAccount ? $bankAccount->phone_number : '';
    $default = $bankAccount ? $bankAccount->is_default : false;
@endphp

<html>
<head> 
    <meta charset="utf-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
    <title>Bank Card Info</title> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
    <link rel="stylesheet" href="/public/site/layui/css/layui.css"> 
    <link rel="stylesheet" href="/public/site/css/common.css"> 
    <style>
        .layui-form-item {
            background: none;
            border-radius: 4px 4px 4px 4px;
            border: 1px solid #DCDCDC;
        }
        .layui-input {
            background: none;
            color: #333333;
            border: none;
        }
    </style>   
</head> 
<body class="common_body"> 
    <div class="common_header common_header_order" style=" "> 
        <a href="javascript:history.back(-1)" class="back position"> 
            <p class="btn"><i class="layui-icon layui-icon-left layui-font-20"></i></p> Bank Card Info 
        </a> 
    </div> 
    <div style="position:relative;top: -60px;margin: 15px"> 
        <div class="common_card"> 
            <div class="common_card_content"> 
                <form action="{{ route('setup.gateway.submit') }}" class="layui-form" lay-filter="saveBankCardInfoForm" method="post">
                    @csrf
                    <input name="id" type="hidden" value=""> 
                    <div class="demo-login-container"> 
                        <div class="layui-form-item"> 
                            <div class="layui-input-wrap"> 
                                <div class="layui-input-prefix"> 
                                    <i class="layui-icon layui-icon-list"></i> 
                                </div> 
                                <select name="bank_code" lay-verify="required" lay-reqtext="Please Select Bank">
                                    <option value="">Please Select Bank</option>
                                    @foreach($bank_list as $bank)
                                        <option value="{{ $bank['bank_code'] }}" @if($bankCode == $bank['bank_code']) selected @endif>
                                            {{ $bank['name'] }}
                                        </option>
                                    @endforeach
                                </select>
                            </div> 
                        </div> 
                        <div class="layui-form-item"> 
                            <div class="layui-input-wrap"> 
                                <div class="layui-input-prefix"> 
                                    <i class="layui-icon layui-icon-username"></i> 
                                </div> 
                                <input type="text" name="realname" value="{{ $accountName }}" lay-verify="required" placeholder="card holder name" autocomplete="off" class="layui-input"> 
                            </div> 
                        </div> 
                        <div class="layui-form-item"> 
                            <div class="layui-input-wrap"> 
                                <div class="layui-input-prefix"> 
                                    <i class="layui-icon layui-icon-layer"></i> 
                                </div> 
                                <input type="text" name="gateway_number" value="{{ $accountNumber }}" lay-verify="required" placeholder="bank account" autocomplete="off" class="layui-input"> 
                            </div> 
                        </div> 
                        <div class="layui-form-item"> 
                            <div class="layui-input-wrap"> 
                                <div class="layui-input-prefix"> 
                                    <i class="layui-icon layui-icon-password"></i> 
                                </div> 
                                <input type="password" name="trade_password" lay-verify="required" placeholder="trade password" autocomplete="off" class="layui-input"> 
                            </div> 
                        </div> 
                        <div class="layui-form-item" style="border: none"> 
                            <button type="submit" class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius" style="background: linear-gradient( 102deg, #27C85D 0%, #24A196 100%);color: #FFFFFF !important;">
                                Add bank card
                            </button> 
                        </div> 
                    </div> 
                </form> 
            </div> 
        </div> 
        <div class="common_card"> 
            <div class="common_card_content"> 
                <div class="demo-login-container" style=""> 
                    <p class="common_explain">Explain</p> 
                    <div class="common_content"> 
                        <p>1. You add only one bank account for withdrawal purposes. </p> 
                        <p>2. Wrong banking details result in loss of funds .</p> 
                        <p>3. No refund in any cases make sure that your bank details is correct.</p> 
                    </div> 
                </div> 
            </div> 
        </div> 
    </div> 
    <img style="position: fixed;
        display: none;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 100%;" src="{{ asset('public/loading.gif') }}" class="loading" alt="">
    <div class="layui-layer-move"></div>
    @include('alert-message')

    <!-- Include layui's JavaScript and initialize the form -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/layui.all.js"></script>
    <script>
        layui.use('form', function() {
            var form = layui.form;

            // Listen for form submission
            form.on('submit(saveBankCardInfoForm)', function(data){
                // Show loading animation
                document.querySelector('.loading').style.display = 'block';

                // Validate all fields before submitting
                var isValid = true;

                // Triggering the verification explicitly for each input
                form.verify({
                    required: function(value, item) {
                        if (!value.trim()) {
                            return 'This field is required!';
                        }
                    }
                });

                // Check if the form is valid
                if (!form.checkValidity()) {
                    // Hide loading animation if form is invalid
                    document.querySelector('.loading').style.display = 'none';
                    isValid = false;
                }

                // If everything is valid, submit the form
                return isValid; // This will allow or prevent the form from being submitted
            });

            // Re-render the form to apply the styles
            form.render();  
        });
    </script>
</body>
</html>